/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.insulation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;

public class AdaptiveInsulation
extends Insulation {
    public static final Codec<AdaptiveInsulation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("value").forGetter(AdaptiveInsulation::getInsulation), (App)Codec.DOUBLE.fieldOf("adapt_speed").forGetter(AdaptiveInsulation::getSpeed), (App)Codec.DOUBLE.fieldOf("factor").forGetter(AdaptiveInsulation::getFactor)).apply((Applicative)instance, AdaptiveInsulation::new));
    private final double insulation;
    private final double speed;
    private double factor;

    public AdaptiveInsulation(double insulation, double speed) {
        this(insulation, 0.0, speed);
    }

    public AdaptiveInsulation(double insulation, double factor, double speed) {
        this.insulation = insulation;
        this.factor = factor;
        this.speed = speed;
    }

    public double getInsulation() {
        return this.insulation;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public double getSpeed() {
        return this.speed;
    }

    @Override
    public double getCold() {
        return CSMath.blend(this.insulation * 0.75, 0.0, this.factor, -1.0, 1.0);
    }

    @Override
    public double getHeat() {
        return CSMath.blend(0.0, this.insulation * 0.75, this.factor, -1.0, 1.0);
    }

    @Override
    public boolean isEmpty() {
        return this.insulation == 0.0;
    }

    @Override
    public List<Insulation> split() {
        ArrayList<Insulation> insulation = new ArrayList<Insulation>();
        for (int i = 0; i < CSMath.ceil(Math.abs(this.insulation) / 2.0); ++i) {
            double insul = CSMath.minAbs(CSMath.shrink(this.insulation, (double)(i * 2)), 2 * CSMath.sign(this.insulation));
            insulation.add(new AdaptiveInsulation(insul, this.factor, this.speed));
        }
        return insulation;
    }

    public String toString() {
        return "AdaptiveInsulation{insulation=" + this.insulation + ", factor=" + this.factor + ", speed=" + this.speed + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdaptiveInsulation)) return false;
        AdaptiveInsulation insul = (AdaptiveInsulation)obj;
        if (this.insulation != insul.insulation) return false;
        if (this.factor != insul.factor) return false;
        if (this.speed != insul.speed) return false;
        return true;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("insulation", this.insulation);
        tag.m_128347_("factor", this.factor);
        tag.m_128347_("speed", this.speed);
        return tag;
    }

    public static AdaptiveInsulation deserialize(CompoundTag tag) {
        return new AdaptiveInsulation(tag.m_128459_("insulation"), tag.m_128459_("factor"), tag.m_128459_("speed"));
    }
}

